#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Blobs_n GooMod01.fsh by  otacocato
//https://www.shadertoy.com/view/4sX3zH
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

/*
  2012 by Felix Weiszig
*/

#define NUM_BLOBS     120
#define BLOB_SIZE_INV 8.0

float samplev (vec2 normFragPos, float aspect)
{
  float valueAll = 0.0;
  for (int i=0; i!=NUM_BLOBS; ++i)
  {
    // create a particle
    vec3 particlePos;
    particlePos.x = sin(sin(iTime*0.05 + float(i*i)))
                  * 0.5 + 0.5;

    particlePos.y = cos(iTime*0.016 + float(i)*0.1)
                    * 0.5 + 0.5;

    // calculate its influence
    float normDist = length(normFragPos/vec2(1.0, aspect)-particlePos.xy);
    normDist = 1.0 - normDist*BLOB_SIZE_INV;
    normDist *= normDist*normDist*(0.5 - abs(0.5 - particlePos.y));
    valueAll += max(0.0, normDist);
  }
	
  return valueAll;
}


//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
  float aspect      = iResolution.x/iResolution.y;
  vec2  normFragPos = fragCoord.xy / iResolution.xy;
	
  float pixelStepX  = 1.0/iResolution.x;
  float pixelStepY  = 1.0/iResolution.y;
	
	
  float sampleXL = samplev(normFragPos + vec2(-pixelStepX, 0.0), aspect);
  float sampleXR = samplev(normFragPos + vec2( pixelStepX, 0.0), aspect);
	
  float diffX = sampleXL - sampleXR;
	
  float sampleYB = samplev(normFragPos + vec2( 0.0, -pixelStepY), aspect);
  float sampleYU = samplev(normFragPos + vec2( 0.0, pixelStepY), aspect);
	
  float diffY = sampleYB - sampleYU;
	
  vec3 gradien = vec3(diffX*5.0, diffY*5.0, 0.125);
  gradien = normalize(gradien);


  float sampleCenter = samplev(normFragPos, aspect);
	
	
  // lighting
  vec3 lightPos = vec3(1.0, 1.5, 2.5);
  vec3 lightDir = normalize(lightPos - vec3(normFragPos, 0.0));
	
  // diffuse
  float nDotL   = max(0.0, dot(gradien, lightDir));
  float diffuse = nDotL;
	
  // specular
  vec3  reflectionDir  = normalize( ( ( 2.0 * gradien ) * nDotL ) - lightDir );
  vec3  viewDir        = normalize((vec3(normFragPos, 1.2)));
  float reflectDotView = max( 0.0, dot( reflectionDir,  viewDir) );
  float specular = max(0.0, pow(reflectDotView, 15.0));
	
  float value = samplev(normFragPos, aspect);

  //fragColor = vec4(gradien,1.0);
  fragColor = texture2D(texture0,
						   vec2(sampleCenter, 0.495)) * diffuse + specular;
  //fragColor = vec4(diffuse,diffuse,diffuse,1.0);
  //fragColor = vec4(specular,specular,specular,1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

